



<html>
<head>
  <title>javabog.dk -  - Pakker</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel5.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel7.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">6 <a name='afsn6'></a>Pakker</H1>
<P LANG="da-DK" CLASS="kapiteloversigt-western">Indhold:</P>
<UL>
  <LI VALUE=1><P LANG="da-DK" CLASS="kapiteloversigt-western">Forst&aring;
  pakkebegrebet og n&oslash;gleordet import</P>
  <LI><P LANG="da-DK" CLASS="kapiteloversigt-western">Importere og
  bruge standardpakkerne</P>
  <LI><P LANG="da-DK" CLASS="kapiteloversigt-western">Definere egne
  pakker</P>
</UL>
<P LANG="da-DK" CLASS="kapiteloversigt-western">Kapitlet foruds&aelig;ttes
ikke i resten af bogen, men er ofte en fordel, n&aring;r man skal
programmere i praksis.</P>
<P LANG="da-DK" CLASS="kapiteloversigt-western">Foruds&aelig;tter
<a href='kapitel4.jsp'>kapitel 4</a>, Definition af klasser.</P>


<P LANG="da-DK" CLASS="western" STYLE="">N&aring;r
man laver st&oslash;rre programmer (over 30-40 klasser), kan det v&aelig;re
nyttigt at opdele dem i grupper. En pakke er en samling af klasser,
der p&aring; en eller anden m&aring;de er besl&aelig;gtede.</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">En pakke er en
navngiven samling af klasser</BLOCKQUOTE>
<P LANG="da-DK" CLASS="western">Javas standardbibliotek p&aring; mere
end 1000 klasser er delt op i ca. 30 mindre pakker.</P>
<P LANG="da-DK" CLASS="western">Pakker svarer til (klasse)biblioteker
i C eller C++ eller &quot;unit&quot;-begrebet i PASCAL.</P>
<H2 CLASS="western">6.1 <a name='afsn6.1'></a>At importere klassedefinitioner</SPAN></H2>
<P LANG="da-DK" CLASS="western">Vi har set, at n&aring;r vi skal
benytte klasser, der ligger ud over de helt grundl&aelig;ggende,
bliver vi n&oslash;dt til at meddele overs&aelig;tteren, hvor den kan
forvente at finde definitionen af klassen. Dette kaldes at importere
klassen.</P>
<P LANG="da-DK" CLASS="western">Egentlig kunne vi godt helt udelade
import-s&aelig;tninger og skrive det fulde pakke- og klassenavn hver
gang. Hvis vi f.eks. vil benytte ArrayList-klassen, kunne vi skrive:</P>
<PRE CLASS="kode-western">    java.util.ArrayList l;
    l = new java.util.ArrayList();</PRE><P LANG="da-DK" CLASS="western">
Det er jo lidt besv&aelig;rligt og derfor kan vi v&aelig;lge &oslash;verst
i kildetekstfilen at skrive:</P>
<PRE CLASS="kode-western">import java.util.ArrayList; </PRE><P LANG="da-DK" CLASS="western">
Dette f&aring;r overs&aelig;tteren til at lede i java.util-pakken,
hvis den m&oslash;der en klasse, den ikke umiddelbart genkender. Nu
kan vi skrive, som vi plejer:</P>
<PRE CLASS="kode-western">    ArrayList l;
    l = new ArrayList();</PRE>
<P LANG="da-DK" CLASS="western">Der kan forekomme et hvilket som
helst antal import-s&aelig;tninger i en javafil. Import-s&aelig;tninger
skal st&aring; f&oslash;rst i filen, f&oslash;r klassedefinitionen.
Hvis man &oslash;nsker at importere flere klassedefinitioner fra
samme pakke, kan man skrive en * i stedet for klassenavnet:</P>
<PRE CLASS="kode-western">import java.util.*; </PRE><P LANG="da-DK" CLASS="western">
Dermed importerer man samtlige klasser fra denne pakke. Det vil sige,
at overs&aelig;tteren leder denne pakke igennem, n&aring;r den
m&oslash;der en klasse, den ikke umiddelbart genkender. De
klassedefinitioner, der ikke bruges, bliver alts&aring; bare
ignoreret.</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">Import af en
klasse g&oslash;r blot definitionen af klassen kendt for overs&aelig;tteren
- det g&oslash;r ikke det f&aelig;rdige program st&oslash;rre eller
langsommere</BLOCKQUOTE>
<H2 CLASS="western">6.2 <a name='afsn6.2'></a>Standardpakkerne</SPAN></H2>
<P LANG="da-DK" CLASS="western">I Javas indbyggede hj&aelig;lpesystem
kan man se de forskellige indbyggede pakker, der indeholder en
r&aelig;kke nyttige klasser. De vigtigste standardpakker er:</P>
<UL>
  <LI><P LANG="da-DK" CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
  java.lang    grundfunktioner i sproget</P>
  <LI><P LANG="da-DK" CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
  java.util    nyttige v&aelig;rkt&oslash;jer, s&aring;som Date,
  ArrayList og meget andet</P>
  <LI><P LANG="da-DK" CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
  java.awt    Abstract Window Toolkit. Grafikprogrammering (se <a href='kapitel9.jsp'>kapitel 9</a>
  og 11)</P>
  <LI><P LANG="da-DK" CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
  java.io    IO-funktioner, filh&aring;ndtering og datastr&oslash;mme
  (se <a href='kapitel15.jsp'>kapitel 15</a>)</P>
  <LI><P LANG="da-DK" CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
  java.net    netv&aelig;rksfaciliteter (se <a href='kapitel16.jsp'>kapitel 16</a>)</P>
  <LI><P LANG="da-DK" CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
  java.rmi    Remote Method Invocation - til distribuerede systemer (se
  <a href='kapitel19.jsp'>kapitel 19</a>)</P>
  <LI><P LANG="da-DK" CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
  java.sql    databaseadgang (ogs&aring; kaldet JDBC, se <a href='kapitel20.jsp'>kapitel 20</a>)</P>
  <LI><P LANG="da-DK" CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
  java.text    h&aring;ndtering af tekst uafh&aelig;ngigt af sprog</P>
  <LI><P LANG="da-DK" CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
  javax.swing  avanceret vinduesbaseret programmering (se
  avanceret-afsnit i <a href='kapitel11.jsp'>kapitel 11</a>)</P>
</UL>
<P LANG="da-DK" CLASS="western" STYLE="">Hvorfor
hedder den sidste javax? javax bet&oslash;d oprindeligt, at det var
en udvidelse til sproget, som ikke var en del af det egentlige
standardbibliotek og som m&aring;ske aldrig bliver det. Efterh&aring;nden
er en del javax-pakker (som javax.swing) dog alligevel kommet med.</P>
<P LANG="da-DK" CLASS="western">Et andet eksempel er javax.comm, som
er en kommunikationspakke, der h&aring;ndterer seriel og parallel
transmission af data. Denne pakke er ikke kommet med i
standardbiblioteket.</P>
<H3 CLASS="western">6.2.1 <a name='afsn6.2.1'></a>Pakken java.lang</H3>
<P LANG="da-DK" CLASS="western">De mest basale javaklasser,
eksempelvis String, ligger i pakken java.lang. Denne s&aelig;rlige
pakke indeholder en masse grundfunktioner og importeres altid af
overs&aelig;tteren. Det er alts&aring; ikke n&oslash;dvendigt at
importere den eksplicit med import java.lang.*;</P>
<P LANG="da-DK" CLASS="western">Af andre klasser i java.lang kan
n&aelig;vnes System (til f.eks. System.out.println()) og Math (til
f.eks. Math.random() og Math.sqrt()).</P>
<H2 CLASS="western">6.3 <a name='afsn6.3'></a>Pakkers placering p&aring; filsystemet</SPAN></H2>
<P LANG="da-DK" CLASS="western">Hvis vi husker, at en pakke er en
navngiven samling af klasser, er det n&aelig;rliggende at t&aelig;nke
p&aring;, hvordan filer er organiseret i undermapper p&aring; et
filsystem.</P>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">En klasse svarer
til en fil p&aring; filsystemet</BLOCKQUOTE>
<BLOCKQUOTE LANG="da-DK" CLASS="definition-western">En pakke svarer
til en undermappe p&aring; filsystemet</BLOCKQUOTE>
<P LANG="da-DK" CLASS="western">For eksempel findes klassen
java.util.ArrayList som filen ArrayList.class i en mappe, der hedder
util, som er en undermappe til en mappe, der hedder java:
java/util/ArrayList.class (i Windows: java\util\ArrayList.class).</P>
<P LANG="da-DK" CLASS="western">Ofte er .class-filerne og mapperne
pakket i et s&aring;kaldt Java-arkiv (.jar-fil). jar-filer minder
meget om zip-filer. 
</P>
<P LANG="da-DK" CLASS="western">Overs&aelig;tteren skal kende pakkens
fysiske placering i filsystemet:</P>
<OL>
  <LI><P LANG="da-DK" CLASS="western">Som en undermappe med samme navn
  som pakken.</P>
  <LI><P LANG="da-DK" CLASS="western">I en undermappe med samme navn
  som pakken et andet sted i filsystemet, som der henvises til med
  CLASSPATH-variablen.</P>
  <LI><P LANG="da-DK" CLASS="western">I en jar-fil, som der henvises
  til med CLASSPATH-variablen.</P>
</OL>
<P LANG="da-DK" CLASS="western">CLASSPATH-variablen er en
milj&oslash;variabel, der minder om PATH-variablen (defineret i
AUTOEXEC.BAT i DOS). Den angiver de steder, hvor overs&aelig;tteren
skal lede efter klassedefinitioner. 
</P>

<H2 CLASS="western" STYLE="">6.4 <a name='afsn6.4'></a>At definere
egne pakker</SPAN></H2>
<P LANG="da-DK" CLASS="western">Man kan definere sine egne pakker.
Dette er specielt brugbart i st&oslash;rre systemer, hvor man har
mange klasser med besl&aelig;gtede funktioner, for eksempel
kommunikation (internetk&oslash;b med VISA eller Dankort) eller sine
egne matematik- eller datobearbejdningspakker.</P>
<P LANG="da-DK" CLASS="western">Det er normalt at man benytter sin
internetadresse eller firmanavn i navngivningen af pakkerne. F.eks:
oracle.JDeveloper.layout.XYLayout (klassen er XYLayout og pakken er
oracle.JDeveloper.layout), com.sybase.jdbc.SybDriver eller
netscape.javascript.JSObject.</P>
<H3 CLASS="western">6.4.1 <a name='afsn6.4.1'></a>Eksempel</H3>
<P LANG="da-DK" CLASS="western">I f&oslash;lgende eksempel findes to
klasser, nemlig Klasse1 og Klasse2 i en pakke (der hedder minPakke).
De bruges af den eksekverbare main()-klasse BenytPakker:</P>
<PRE CLASS="ikke-javakode-western"><B>import minPakke.*;</B>

public class BenytPakker
{
  public static void main(String[] arg)
  {
    Klasse1 a = new Klasse1();
    Klasse2 b = new Klasse2();
    a.snak();
    b.snak();
  }
}</PRE>
<P LANG="da-DK" CLASS="western">Klasse1 og Klasse2 skal ligge i en
undermappe, der hedder minPakke:</P>
<PRE CLASS="ikke-javakode-western"><I>// Filnavn: minPakke/Klasse1.java</I>
<B>package minPakke;</B>

public class Klasse1
{
  public void snak()
  {
    System.out.println(&quot;Dette er Klasse1, der taler!&quot;);
  }
}</PRE>
<PRE CLASS="ikke-javakode-western"><I>// Filnavn: minPakke/Klasse2.java</I>
<B>package minPakke;</B>

public class Klasse2
{
  public void snak()
  {
    System.out.println(&quot;Dette er Klasse2, der taler!&quot;);
  }
}</PRE><H2 CLASS="western">
6.5 <a name='afsn6.5'></a>Pakke klasser i jar-filer (Java-arkiver)</SPAN></H2>
<P LANG="da-DK" CLASS="western">Laver man sine egne pakker, &oslash;nsker
man ofte at kunne distribuere de oversatte .class-filer med nytekoden
til andre. Det g&oslash;res nemmest ved at pakke filerne i en
jar-fil. 
</P>
<P LANG="da-DK" CLASS="western">En jar-fil skabes med et zip-v&aelig;rkt&oslash;j
som WinZip eller GnoZip til Linux eller fra kommandolinjen med
kommandoen <B>jar</B>, der f&oslash;lger med, n&aring;r man
installerer Java. Den minder meget om UNIX' tar-kommando. Man
opretter et arkiv ved at skrive f.eks.:</P>
<PRE CLASS="western">  jar cf program.jar *.class minPakke</PRE><P LANG="da-DK" CLASS="western">
Dette vil oprette jar-filen program.jar med alle class-filer i mappen
(herunder BenytPakker.class) og alle filerne i undermappen minPakke
(d.v.s. minPakke/Klasse1.class og minPakke/Klasse2.class). 
</P>
<P LANG="da-DK" CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
Derefter kan main()-metoden i BenytPakker udf&oslash;res ved at blot
skrive</P>
<PRE CLASS="western">  java -cp program.jar BenytPakker</PRE><H3 CLASS="western">
6.5.1 <a name='afsn6.5.1'></a>Eksekverbare jar-filer</H3>
<P LANG="da-DK" CLASS="western">Hvis man vil distribuere sit program
til mange mennesker, kan det v&aelig;re bekvemt, at brugerne kan
dobbeltklikke p&aring; jar-filen, lige som f.eks. Windows-brugere
dobbeltklikker p&aring; .exe-filer. Det kr&aelig;ver, at man l&aelig;gger
en s&aring;kaldt manifest-fil med ned i jar-filen:</P>
<PRE CLASS="western">  jar cf<B>m</B> program.jar <B>manifestfil.txt</B> *.class minPakke</PRE><P LANG="da-DK" CLASS="western">
Filen manifestfil.txt angiver klassen med main()-metoden:</P>
<PRE CLASS="kode-western">Manifest-Version: 1.0
Main-Class: BenytPakker</PRE><P LANG="da-DK" CLASS="western">
Der er et par irriterende sm&aring;ting der kan give problemer,
herunder fil- og mappeplacering og at manifestfilen skal afslutte med
et linjeskift. Mange bruger derfor deres udviklingsv&aelig;rkt&oslash;j
til at lave jar-filen (JBuilder: File|New|Archive|Application) eller
&aelig;ndrer en eksisterende jar-fil med WinZip eller et andet
v&aelig;rkt&oslash;j der kan rette i ZIP-filer.</P>
<P LANG="da-DK" CLASS="western">Til sidst kan man k&oslash;re
BenytPakker ved at at dobbeltklikke p&aring; program.jar (hvis
filassociationerne er sat korrekt op). Ellers kan man fra
kommandolinjen starte programmet med:</P>
<PRE CLASS="western">  java -jar program.jar</PRE>
<H2 CLASS="western">6.6 <a name='afsn6.6'></a>Test dig selv</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel6.jsp#afsn6.6">
  <input type='checkbox' name='vis' value='6.6'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='6.6'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western">6.7 <a name='afsn6.7'></a>Resum&eacute;</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel6.jsp#afsn6.7">
  <input type='checkbox' name='vis' value='6.7'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='6.7'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western">6.8 <a name='afsn6.8'></a>Opgaver</SPAN></H2>
<OL>
  <LI><P LANG="da-DK" CLASS="western">S&oslash;g i din computer efter
  filer, der ender p&aring; .jar og &aring;bn dem med et program, der
  kan l&aelig;se ZIP-komprimerede filer (f.eks unzip eller WinZip).
  <BR>Hvordan er filerne organiseret?</P>
  <LI><P LANG="da-DK" CLASS="western">Se, om du kan finde filen, der
  indeholder ArrayList-klassen. <BR>I hvilken undermappe ligger den?</P>
  <LI><P LANG="da-DK" CLASS="western">Opret nogle klasser i en pakke
  og en main()-klasse, der benytter dem <BR>(f.eks. BenytPakker.java,
  minPakke/Klasse1.java og minPakke/Klasse2.java).</P>
  <LI><P LANG="da-DK" CLASS="western">Pak dem i en jar-fil.</P>
  <LI><P LANG="da-DK" CLASS="western">Pr&oslash;v at oprette en
  eksekverbar jar-fil. Pr&oslash;v derefter at  k&oslash;re den.</P>
</OL>
<P LANG="da-DK" CLASS="western">Til de sidste tre opgaver kan det
v&aelig;re en fordel at g&aring; ind p&aring; den elektroniske udgave
af bogen, <A CLASS="western" HREF="http://javabog.dk/">http://javabog.dk</A>
 og kopiere teksten i stedet for at taste den ind.</P>
<H2 CLASS="western" STYLE="">6.9 <a name='afsn6.9'></a>Avanceret:
public, protected og private</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel6.jsp#afsn6.9">
  <input type='checkbox' name='vis' value='6.9'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='6.9'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">6.9.1 <a name='afsn6.9.1'></a>Variabler og metoder</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel6.jsp#afsn6.9.1">
  <input type='checkbox' name='vis' value='6.9.1'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='6.9.1'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">6.9.2 <a name='afsn6.9.2'></a>Indkapsling med pakker</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel6.jsp#afsn6.9.2">
  <input type='checkbox' name='vis' value='6.9.2'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='6.9.2'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">6.9.3 <a name='afsn6.9.3'></a>Klasser</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel6.jsp#afsn6.9.3">
  <input type='checkbox' name='vis' value='6.9.3'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='6.9.3'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel5.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel7.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b></b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (79% af vrket).
</font>
<br>
nsker du at se de sidste 21% af dette vrk (226970 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
